package ru.yandex.autotests.direct.api.campaigns.add.notification;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 03.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля WarningBalance в настройках нотификаций кампании при её создании")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class EmailSettingsWarningBalanceValidationTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public int warningBalance;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "WarningBalance = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {EmailSettingsMap.MIN_WARNING_BALANCE, ExpectedResult.success()},
                {EmailSettingsMap.MAX_WARNING_BALANCE / 2, ExpectedResult.success()},
                {EmailSettingsMap.MAX_WARNING_BALANCE, ExpectedResult.success()},
                {EmailSettingsMap.MIN_WARNING_BALANCE - 1,
                        ExpectedResult.errorsIgnoringDetails(new Notification(5005, Api5ErrorDetails.MINIMUM_WARNING_BALANCE_SHOULD_BE,
                                EmailSettingsMap.MIN_WARNING_BALANCE, EmailSettingsMap.MAX_WARNING_BALANCE))},
                {EmailSettingsMap.MAX_WARNING_BALANCE + 1,
                        ExpectedResult.errorsIgnoringDetails(new Notification(5005, Api5ErrorDetails.MINIMUM_WARNING_BALANCE_SHOULD_BE,
                                EmailSettingsMap.MIN_WARNING_BALANCE, EmailSettingsMap.MAX_WARNING_BALANCE))},
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("184")
    public void addCampaignWithNotificationWarningBalance() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign()
                        .withNotification(new NotificationMap()
                                .defaultNotification()
                                .withEmailSettings(new EmailSettingsMap()
                                        .defaultEmailSettings()
                                        .withWarningBalance(warningBalance)))),
                expectedResult);
    }
}
