package ru.yandex.autotests.direct.api.campaigns.add.servicingcampaign;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 8/4/16.
 * https://st.yandex-team.ru/TESTIRT-9974
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Если у клиента нет сервисируемых кампаний на логине, то все новые также не сервисируемые. Параметр REQUIRE_SERVICING не передаем в запросе")
@Issue("https://st.yandex-team.ru/DIRECT-55839")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ServicingCampaignDefaultTest {

    @Parameterized.Parameter(0)
    public static String description;

    @Parameterized.Parameter(1)
    public static String client;

    @Parameterized.Parameter(2)
    public static YesNoEnum expectedRequireServicingState;

    @Parameterized.Parameter(3)
    public static Boolean expectedClientServicingState;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"клиент с сервисируемыми кампаниями", Logins.LOGIN_FOR_RUB, YesNoEnum.YES, true},
                {"клиент без сервисируемых кампаний", Logins.CLIENT_WITH_NOT_SERVICING_CAMPAIGNS, YesNoEnum.NO, false}
        });
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private boolean isClientServicing() {
        //получаем список Id'шников всех кампаний клиента
        List<CampaignGetItem> campaignsList = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                        new CampaignsSelectionCriteriaMap()).withFieldNames(CampaignFieldEnum.ID)).getCampaigns();
        List<Long> campaignsIdList = campaignsList.stream().map(CampaignGetItem::getId).collect(Collectors.toList());

        for (Long oldCampaignId : campaignsIdList) {
            CampaignsRecord campaigns = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps()
                    .getCampaignById(oldCampaignId);
            if (campaigns.getManageruid() != null) {
                return true;
            }
        }
        return false;
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("190")
    public void checkServicingApiV5() {
        api.as(client);
        assumeThat("Сервисируемость клиента соответствует ожиданиям", isClientServicing(),
                equalTo(expectedClientServicingState));
        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.SETTINGS));

        List<TextCampaignSettingGet> settings = getResponse.getCampaigns().get(0).getTextCampaign().getSettings();
        YesNoEnum isNewCampaignServiced = null;
        for (TextCampaignSettingGet textCampaignSettingGet : settings) {
            if (textCampaignSettingGet.getOption().value().equals(TextCampaignSettingsEnum.REQUIRE_SERVICING.value())) {
                isNewCampaignServiced = textCampaignSettingGet.getValue();
                break;
            }
        }
        assertThat("параметр REQUIRE_SERVICING выставлен в нужное положение", isNewCampaignServiced,
                equalTo(expectedRequireServicingState));
    }
}
