package ru.yandex.autotests.direct.api.campaigns.add.servicingcampaign;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 8/19/16.
 * https://st.yandex-team.ru/TESTIRT-9974
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Если у клиента нет кампаний на логине, то все новые также не сервисируемые.")
@Issue("https://st.yandex-team.ru/DIRECT-55839")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ServicingCampaignWithoutCampaignsTest {
    private static final String CLIENT = Logins.CLIENT_WITHOUT_CAMPAIGNS;

    @Parameterized.Parameter()
    public static String description;

    @Parameterized.Parameter(1)
    public static YesNoEnum requireServicingValue;

    @Parameterized.Parameter(2)
    public static YesNoEnum expectedRequireServicingState;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"клиент без кампаний, передаем RS=Yes", YesNoEnum.YES, YesNoEnum.NO},
                {"клиент без кампаний, передаем RS=NO", YesNoEnum.NO, YesNoEnum.NO}
        });
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private void deleteAllClientsCampaigns() {
        List<CampaignGetItem> campaignsList = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                        new CampaignsSelectionCriteriaMap()).withFieldNames(CampaignFieldEnum.ID)).getCampaigns();

        if (campaignsList.isEmpty()) {
            return;
        }

        api.userSteps.deleteActiveCampaignsQuietly(CLIENT,
                campaignsList.stream().map(CampaignGetItem::getId).toArray(Long[]::new));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("191")
    public void checkServicingApiV5() {
        deleteAllClientsCampaigns();
        long campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withSettings(new TextCampaignSettingMap()
                                        .withOption(TextCampaignSettingsEnum.REQUIRE_SERVICING)
                                        .withValue(requireServicingValue))));
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.SETTINGS));

        List<TextCampaignSettingGet> settings = getResponse.getCampaigns().get(0).getTextCampaign().getSettings();
        YesNoEnum isNewCampaignServiced = null;
        for (TextCampaignSettingGet textCampaignSettingGet : settings) {
            if (textCampaignSettingGet.getOption().value().equals(TextCampaignSettingsEnum.REQUIRE_SERVICING.value())) {
                isNewCampaignServiced = textCampaignSettingGet.getValue();
                break;
            }
        }
        assertThat("параметр REQUIRE_SERVICING выставлен в нужное положение", isNewCampaignServiced,
                equalTo(expectedRequireServicingState));
    }
}
