package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import java.io.IOException;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionCrrAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionCrrAddMap.DEFAULT_CRR;
import static ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-151192")
@Features(CampaignsFeatures.ADD)
@Description("Проверка выставления source для кц в зависимости от типа стратегии")
@Tag(TagDictionary.TRUNK)
public class AddTextCampaignWithMeaningfulGoalValueMetrikaSourceTest {
    private static final String LOGIN = CampaignsLogins.CLIENT;

    private static final Integer COUNTER_ID = MetrikaGoals.getCounterForLogin(LOGIN);
    private static final Long GOAL_ID = MetrikaGoals.getGoalForCounter(COUNTER_ID);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private int shard;

    ObjectMapper mapper = new ObjectMapper();

    @Before
    public void before() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    public void addCrrCampaignWithMeaningfulGoalsWithMetrikaSource_SourceSaved() throws IOException {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withCounterIds(COUNTER_ID)
                        .withPriorityGoals(new PriorityGoalsItemMap()
                                .withGoalId(GOAL_ID)
                                .withIsMetrikaSourceOfValue(YesNoEnum.YES)
                                .withValue(13_000_000L)
                        )
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_CRR)
                                        .withPayForConversionCrr(new StrategyPayForConversionCrrAddMap()
                                                .withGoalId(GOAL_ID)
                                                .withCrr(DEFAULT_CRR)
                                                .withWeeklySpendLimit(DEFAULT_WEEKLY_SPEND_LIMIT)
                                        )
                                )
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                        )
                )
        );

        CampOptionsRecord campaignRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(cid);
        String meaningfulGoals = campaignRecord.getMeaningfulGoals();
        int isMetrikaSourceOfValue = mapper.readTree(meaningfulGoals).elements().next().get(
                "is_metrika_source_of_value").asInt();
        assertThat("Источник кц соответствует ожиданиям",
                isMetrikaSourceOfValue,
                equalTo(1));
    }

    @Test
    public void addCrrCampaignWithMeaningfulGoalsWithoutMetrikaSource_SourceNotSaved() throws IOException {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withCounterIds(COUNTER_ID)
                        .withPriorityGoals(new PriorityGoalsItemMap()
                                .withGoalId(GOAL_ID)
                                .withValue(13_000_000L)
                        )
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_CRR)
                                        .withPayForConversionCrr(new StrategyPayForConversionCrrAddMap()
                                                .withGoalId(GOAL_ID)
                                                .withCrr(DEFAULT_CRR)
                                                .withWeeklySpendLimit(DEFAULT_WEEKLY_SPEND_LIMIT)
                                        )
                                )
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                        )
                )
        );

        CampOptionsRecord campaignRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(cid);
        String meaningfulGoals = campaignRecord.getMeaningfulGoals();
        JsonNode isMetrikaSourceOfValue = mapper.readTree(meaningfulGoals).elements().next().get(
                "is_metrika_source_of_value");
        assertThat("Источник кц соответствует ожиданиям",
                isMetrikaSourceOfValue,
                nullValue());
    }

    @Test
    public void addNotCrrCampaignWithMeaningfulGoalsWithMetrikaSource_HasError() {
        ExpectedResult expectedResult = ExpectedResult.errors(
                new Notification(5005, Api5ErrorDetails.INVALID_VALUE_SOURCE, 0, "true"));

        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .withCounterIds(COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsItemMap()
                                        .withGoalId(GOAL_ID)
                                        .withIsMetrikaSourceOfValue(YesNoEnum.YES)
                                        .withValue(13_000_000L)
                                )
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withSearch(new TextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                                                .withPayForConversion(new StrategyPayForConversionAddMap()
                                                        .withGoalId(GOAL_ID)
                                                        .withCpa(1_000_000_00L)
                                                        .withWeeklySpendLimit(DEFAULT_WEEKLY_SPEND_LIMIT)
                                                )
                                        )
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                                )
                        )),
                expectedResult
        );
    }

    @Test
    public void addNotCrrCampaignWithoutMeaningfulGoalsWithMetrikaSource_HasError() throws IOException {
        Long campaignId =
                api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withCounterIds(COUNTER_ID)
                        .withPriorityGoals(new PriorityGoalsItemMap()
                                .withGoalId(GOAL_ID)
                                .withIsMetrikaSourceOfValue(YesNoEnum.NO)
                                .withValue(13_000_000L)
                        )
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                                        .withPayForConversion(new StrategyPayForConversionAddMap()
                                                .withGoalId(GOAL_ID)
                                                .withCpa(1_000_000_00L)
                                                .withWeeklySpendLimit(DEFAULT_WEEKLY_SPEND_LIMIT)
                                        )
                                )
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                        )
                ));

        CampOptionsRecord campaignRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(campaignId);
        String meaningfulGoals = campaignRecord.getMeaningfulGoals();
        int isMetrikaSourceOfValue = mapper.readTree(meaningfulGoals).elements().next().get(
                "is_metrika_source_of_value").asInt();
        assertThat("Источник кц соответствует ожиданиям",
                isMetrikaSourceOfValue,
                equalTo(0));
    }
}
