package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.AttributionModelEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaignsext.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-154353")
@Features(CampaignsFeatures.ADD)
@Description("Проверка поля AttributionModel. Негативный сценарий для новых типов")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CrossDeviceAttributionModelAddNegativeTest {
    private static final String CLIENT = CampaignsLogins.CLIENT_NEW_FEATURES;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Parameterized.Parameter(0)
    public AttributionModelEnum initialAttributionModel;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "AttributionModel = {0}")
    public static Collection testData() {
        ExpectedResult success = ExpectedResult.success();
        ExpectedResult errors = ExpectedResult.errors(new Notification(5005,
                Api5ErrorDetails.INCORRECT_ATTRIBUTION_MODEL_SPECIFIED));

        Object[][] data = new Object[][]{
                {AttributionModelEnum.FC, success},
                {AttributionModelEnum.LC, success},
                {AttributionModelEnum.LSC, success},
                {AttributionModelEnum.LYDC, success},
                {AttributionModelEnum.FCCD, errors},
                {AttributionModelEnum.LSCCD, errors},
                {AttributionModelEnum.LYDCCD, errors},
                {null, success},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

        DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        Long clientId = Long.parseLong(User.get(CLIENT).getClientID());
        dbSteps.featuresSteps().setClientFeature(clientId, "cross_device_attribution_types", false);
    }

    @Test
    public void checkCampaignAttributionModel() {
        api.userSteps.campExtSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(campaignAddItemMap()),
                expectedResult
        );
    }

    private CampaignAddItemMap campaignAddItemMap() {
        return new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .defaultTextCampaign()
                        .withAttributionModel(initialAttributionModel));
    }

}
