package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.MetrikaCountersSource;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MetrikaCountersRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("При создание кампании через api записывать источник счетчика")
@Issue("https://st.yandex-team.ru/DIRECT-121108")
@RunWith(Parameterized.class)
public class MetrikaCounterSourceDbTest {
    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static final String CLIENT = CampaignsLogins.CLIENT_WITH_METRIKA_SPRAV;
    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);
    private static final Integer CLIENT_COUNTER_ID = 87695860;
    // про счетчик CLIENT_COUNTER_ID подробности в тикете https://st.yandex-team.ru/DIRECT-122396#5ef212cbebc41042b0e4126d
    private static final Integer UNKNOWN_COUNTER_ID = RandomUtils.getRandomInteger(1, 1000000);
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public String description;
    @Parameterized.Parameter(value = 1)
    public Integer counterId;
    @Parameterized.Parameter(value = 2)
    public MetrikaCountersSource expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Создание кампании с клиентским счетчиком", CLIENT_COUNTER_ID, MetrikaCountersSource.sprav},
                {"Создание кампании с чужим счетчиком", UNKNOWN_COUNTER_ID, MetrikaCountersSource.unknown},
        });
    }

    @BeforeClass
    public static void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void addCampaignWithCounterExpectValidSourceInDb() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                                .withCounterIds(counterId))),
                ExpectedResult.success());

        assumeThat("получили результаты добавления кампании", response.getAddResults(), hasSize(1));
        Long campaignId = response.getAddResults().get(0).getId();
        MetrikaCountersRecord metrikaCounterRecord =
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).metrikaCountersSteps()
                        .getMetrikaCounters(campaignId);
        assumeThat("получили данные из metrika_counters", metrikaCounterRecord, notNullValue());
        assertThat("metrika_counters.source соответствует ожиданиям",
                metrikaCounterRecord.getSource(),
                equalTo(expectedResult));
    }

}

