package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import java.math.BigInteger;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampOptionsBroadMatchFlag;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.Assume.assumeThat;
import static org.junit.Assume.assumeTrue;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка включения ДРФ по умолчанию при создании")
@Issue("https://st.yandex-team.ru/DIRECT-68257")
@ParametersAreNonnullByDefault
public class RelevantKeywordsEnableByDefaultTest {
    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Integer CUSTOM_BUDGET_PERCENT = 75;
    private static final Integer DEFAULT_BUDGET_PERCENT = 40;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;

    @BeforeClass
    public static void prepare() {
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @Description("При создании кампании с указанием блока RelevantKeywords ДРФ дожен включиться")
    public void addWithRelevantKeywordsTest() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withTextCampaign(new TextCampaignAddItemMap()
                                        .withBiddingStrategy(
                                                new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                                        .withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                                                .withBudgetPercent(CUSTOM_BUDGET_PERCENT)
                                                .withOptimizeGoalId(null)))),
                ExpectedResult.success()
        );

        Long campaignId = addResponse.getAddResults().get(0).getId();

        CampOptionsRecord expectedCampOptionsAfter = new CampOptionsRecord();
        expectedCampOptionsAfter.setBroadMatchFlag(CampOptionsBroadMatchFlag.Yes);
        expectedCampOptionsAfter.setBroadMatchLimit(CUSTOM_BUDGET_PERCENT);
        expectedCampOptionsAfter.setBroadMatchGoalId(null);

        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(campaignId);

        assumeTrue("корректные настройки ДРФ", matchCampOptionsDrfSettings(campOptions, expectedCampOptionsAfter));

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignId)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS)
        );

        assertThat("вернулась ожидаемая структура RelevantKeyword",
                getResponse.getCampaigns().get(0).getTextCampaign(),
                beanDifferV5(new TextCampaignGetItemMap().withRelevantKeywords(
                        new RelevantKeywordsSettingMap()
                                .withBudgetPercent(CUSTOM_BUDGET_PERCENT)
                                .withOptimizeGoalId(null)).getBean()));
    }

    @Test
    @Description("При создании кампании с указанием настройки ENABLE_RELATED_KEYWORDS = YES ДРФ дожен включиться")
    public void addWithoutRelevantKeywordsAndWithEnableRelatedKeywordsSettingTest() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withTextCampaign(new TextCampaignAddItemMap()
                                        .withBiddingStrategy(
                                                new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                                        .withSettings(new TextCampaignSettingMap()
                                                .withOption(TextCampaignSettingsEnum.ENABLE_RELATED_KEYWORDS)
                                                .withValue(YesNoEnum.YES)))),
                ExpectedResult.warningsIgnoringDetailsAndMessage(new Notification(10163, Api5ErrorDetails.CAMPAIGN_SETTING_DEPRECATED,
                        TextCampaignSettingsEnum.ENABLE_RELATED_KEYWORDS))
        );

        Long campaignId = addResponse.getAddResults().get(0).getId();

        CampOptionsRecord expectedCampOptionsAfter = new CampOptionsRecord();
        expectedCampOptionsAfter.setBroadMatchFlag(CampOptionsBroadMatchFlag.Yes);
        expectedCampOptionsAfter.setBroadMatchLimit(DEFAULT_BUDGET_PERCENT);
        expectedCampOptionsAfter.setBroadMatchGoalId(null);

        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(campaignId);

        assumeTrue("корректные настройки ДРФ", matchCampOptionsDrfSettings(campOptions, expectedCampOptionsAfter));

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignId)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS)
        );

        assertThat("вернулась ожидаемая структура RelevantKeyword",
                getResponse.getCampaigns().get(0).getTextCampaign(),
                beanDifferV5(new TextCampaignGetItemMap().withRelevantKeywords(
                        new RelevantKeywordsSettingMap()
                                .withBudgetPercent(DEFAULT_BUDGET_PERCENT)
                                .withOptimizeGoalId(null)).getBean()));
    }

    @Test
    @Description("При создании кампании без указания блока RelevantKeywords и настройки ENABLE_RELATED_KEYWORDS = YES ДРФ не дожен включиться")
    public void addWithoutRelevantKeywordsAndWithoutEnableRelatedKeywordsSettingTest() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withTextCampaign(new TextCampaignAddItemMap()
                                        .withBiddingStrategy(
                                                new TextCampaignStrategyAddMap().defaultTextCampaignStrategy()))),
                ExpectedResult.success());

        Long campaignId = addResponse.getAddResults().get(0).getId();

        CampOptionsRecord expectedCampOptionsAfter = new CampOptionsRecord();
        expectedCampOptionsAfter.setBroadMatchFlag(CampOptionsBroadMatchFlag.No);
        expectedCampOptionsAfter.setBroadMatchLimit(0);
        expectedCampOptionsAfter.setBroadMatchGoalId(BigInteger.ZERO);

        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(campaignId);

        assumeTrue("корректные настройки ДРФ", matchCampOptionsDrfSettings(campOptions, expectedCampOptionsAfter));

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignId)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS)
        );

        assertThat("вернулась ожидаемая структура RelevantKeyword",
                getResponse.getCampaigns().get(0).getTextCampaign().getRelevantKeywords(),
                beanDifferV5(new ObjectFactory().createTextCampaignBaseRelevantKeywords(null)));
    }

    private boolean matchCampOptionsDrfSettings(CampOptionsRecord actual, CampOptionsRecord expected) {
        assumeThat("BroadMatchFlag совпадает",
                actual.getBroadMatchFlag(),
                Matchers.equalTo(expected.getBroadMatchFlag()));
        assumeThat("BroadMatchLimit совпадает",
                actual.getBroadMatchLimit(),
                Matchers.equalTo(expected.getBroadMatchLimit()));
        assumeThat("BroadMatchGoalId совпадает",
                actual.getBroadMatchGoalId(),
                Matchers.equalTo(expected.getBroadMatchGoalId()));
        return true;
    }
}
