package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.RelevantKeywordsModeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 07.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 * https://st.yandex-team.ru/TESTIRT-8645
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля RelevantKeywordsSetting.BudgetPercent. Негативные сценарии")
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-34567"),
        @Issue("https://st.yandex-team.ru/DIRECT-50424"),
})
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class RelevantKeywordsSettingBudgetPercentNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public Integer budgetPercent;

    @Parameterized.Parameters(name = "BudgetPercent = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {-10},
                {-1},
                {0},
                {110},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("194")
    public void addWithCounterIds() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withTextCampaign(new TextCampaignAddItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                                        .withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                                                .withBudgetPercent(budgetPercent)
                                                .withMode(RelevantKeywordsModeEnum.OPTIMAL)))
                        ),
                ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005,
                                Api5ErrorDetails.BUDGET_EXPENDITURE_FOR_ADDITIONAL_RELEVANT_PHRASES_SPECIFIED_INCORRECTLY)));
    }
}
