package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.RelevantKeywordsModeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 07.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 * https://st.yandex-team.ru/TESTIRT-8645
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля RelevantKeywordsSetting.BudgetPercent. Позитивные сценарии")
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-34567"),
        @Issue("https://st.yandex-team.ru/DIRECT-50424"),
})
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class RelevantKeywordsSettingBudgetPercentPositiveTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public Integer budgetPercent;

    @Parameterized.Parameters(name = "BudgetPercent = {0}")
    public static Collection<Object[]> data() throws UnsupportedEncodingException {
        return Arrays.asList(new Object[][]{
                {1},
                {50},
                {100},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("195")
    public void addWithBudgetPercentAndCheckSave() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withTextCampaign(new TextCampaignAddItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                                        .withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                                                .withBudgetPercent(budgetPercent)
                                                .withMode(RelevantKeywordsModeEnum.OPTIMAL)))

                        ),
                ExpectedResult.success());
        Long id = addResponse.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        assertThat("поле BudgetPercent сохранилось верно", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(new TextCampaignGetItemMap()
                                        .withRelevantKeywords(new RelevantKeywordsSettingMap()
                                                .withBudgetPercent(budgetPercent)
                                                .withOptimizeGoalId(0L))).getBean()));
    }
}
