package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import java.math.BigInteger;

import com.yandex.direct.api.v5.campaigns.RelevantKeywordsModeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 28.01.16.
 * https://st.yandex-team.ru/TESTIRT-8330
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации RelevantKeywordsSetting")
@Issue("https://st.yandex-team.ru/DIRECT-49749")
public class RelevantKeywordsSettingTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("200")
    public void addWithModeAndBudgetPercent() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withTextCampaign(new TextCampaignAddItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                                        .withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                                                .withBudgetPercent(100)
                                                .withMode(RelevantKeywordsModeEnum.OPTIMAL)))
                        ),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("196")
    public void addWithModeAndBudgetPercentAndCheckGoalIdIsZero() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                        .withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                                .withBudgetPercent(100)
                                .withMode(RelevantKeywordsModeEnum.OPTIMAL)))
        );

        assertThat("OptimizeGoalId выставился в 0",
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampOptionsById(cid).getBroadMatchGoalId(),
                equalTo(BigInteger.ZERO));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("197")
    public void addWithModeAndBudgetPercentAndCheckAndZeroGoalId() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                        .withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                                .withBudgetPercent(100)
                                .withMode(RelevantKeywordsModeEnum.OPTIMAL)
                                .withOptimizeGoalId(0L)))
        );
        assertThat("OptimizeGoalId выставился в 0",
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampOptionsById(cid).getBroadMatchGoalId(),
                equalTo(BigInteger.ZERO));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("198")
    public void addWithModeAndBudgetPercentAndCheckAndNullGoalId() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                        .withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                                .withBudgetPercent(100)
                                .withMode(RelevantKeywordsModeEnum.OPTIMAL)
                                .withOptimizeGoalId(null)))
        );
        assertThat("OptimizeGoalId не выставился",
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                        .getCampOptionsById(cid).getBroadMatchGoalId(), nullValue());

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("199")
    public void addWithModeAndBudgetPercentAndNegativeGoalId() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withTextCampaign(new TextCampaignAddItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())
                                        .withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                                                .withBudgetPercent(100)
                                                .withMode(RelevantKeywordsModeEnum.OPTIMAL)
                                                .withOptimizeGoalId((long) -1)))
                        ),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(RelevantKeywordsSettingMap.OPTIMIZE_GOAL_ID)),
                                new Notification(8800,
                                        Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                        capitalize(RelevantKeywordsSettingMap.OPTIMIZE_GOAL_ID))
                                ))
                        .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(RelevantKeywordsSettingMap.OPTIMIZE_GOAL_ID))))
        );
    }


}
