package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации пустого блока RelevantKeywordsSetting. Негативный сценарий.")
@Issue("https://st.yandex-team.ru/DIRECT-70211")
public class RelevantKeywordsStructureNegativeJsonTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void emptyRelevantKeywordsSettingSectionOnAddTest() {
        JsonObject textCampaign = new JsonObject()
                .with(capitalize(TextCampaignAddItemMap.BIDDING_STRATEGY),
                        new TextCampaignStrategyAddMap().defaultTextCampaignStrategy().getBean())
                .with(capitalize(TextCampaignAddItemMap.RELEVANT_KEYWORDS), new JsonObject());

        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.TEXT_CAMPAIGN), textCampaign);

        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS), new Object[]{campaign});

        api.userSteps.campaignSteps()
                .expectErrorOnCampaignsAdd(request, new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(TextCampaignAddItemMap.RELEVANT_KEYWORDS),
                        capitalize(RelevantKeywordsSettingAddMap.BUDGET_PERCENT)));
    }
}
