package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка консистентности стратегии и настроек ДРФ")
@Issue("https://st.yandex-team.ru/DIRECT-68661")
@Tag(TagDictionary.TRUNK)
public class RelevantKeywordsSwitchedOffOnApplyingStrategyWithoutImpressionsOnSearchTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final int DEFAULT_BUDGET_PERCENT = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void relevantKeywordsSwitchedOffOnApplyingStrategyWithoutImpressionsOnSearch() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withTextCampaign(new TextCampaignAddItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                                        .defaultServingOff()) // NB: важное условие
                                                .withNetwork(new TextCampaignNetworkStrategyAddMap()
                                                        .defaultAverageCpc(Currency.RUB)))
                                        .withRelevantKeywords(new RelevantKeywordsSettingAddMap()
                                                .withBudgetPercent(DEFAULT_BUDGET_PERCENT)))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.warningWithCode(10173))
                        .perl(ExpectedResult.warnings(new Notification(10173,
                                Api5ErrorDetails.RELEVANT_KEYWORDS_USELESS_FOR_CHOSEN_STRATEGY))));

        assumeThat("Создана текстовая кампания", addResponse.getAddResults(), hasSize(1));

        List<CampaignGetItem> listOfCampaigngtItem =
                api.userSteps.campaignSteps().getCampaigns(new GetRequestMap().withSelectionCriteria(
                        new CampaignsSelectionCriteriaMap().withIds(addResponse.getAddResults().get(0).getId()))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));

        assumeThat("Получена кампания", listOfCampaigngtItem, hasSize(1));
        assumeThat("Получена текстовая кампания", listOfCampaigngtItem.get(0).getTextCampaign(), notNullValue());
        assumeThat("ДРФ отключены", listOfCampaigngtItem.get(0).getTextCampaign().getRelevantKeywords().isNil(),
                is(true));
    }

}
