package ru.yandex.autotests.direct.api.campaigns.add.textcampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.beans.campaign.StrategyDataJava;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка сохранения составных целей у стратегий в кампаниях")
@Issue("https://st.yandex-team.ru/DIRECT-142160")
@RunWith(Parameterized.class)
public class StepGoalAddTest {

    private static final int CPA_MULTIPLIER = 1000000;
    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Integer COUNTER_ID = 31844711;
    private static final Currency CURRENCY = Currency.RUB;
    private static final Long AVERAGE_CPA = MoneyCurrency.get(CURRENCY).getMinAveragePrice().multiply(10).bidLong().longValue() / CPA_MULTIPLIER;

    private static int shard;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public Long goalId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data =  new Object[][] {
                {
                        "Сохранение кампании с подцелью составной цели",
                        19723215L
                },
                {
                        "Сохранение кампании с передачей составной цели по номеру",
                        19723210L
                }
        };
        return Arrays.asList(data);
    }


    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void addCampaignWithStepGoalTest() {
        TextCampaignAddItemMap textCampaignAddItemMap = new TextCampaignAddItemMap()
                .withCounterIds(COUNTER_ID)
                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                        .withSearch(new TextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                                .withAverageCpa(new StrategyAverageCpaAddMap()
                                        .withAverageCpa(AVERAGE_CPA * CPA_MULTIPLIER)
                                        .withGoalId(goalId)))
                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff()));

        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(textCampaignAddItemMap));

        CampaignsRecord actualCampaignsRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid);
        CampaignsRecord expectedCampaignsRecord = new CampaignsRecord();
        expectedCampaignsRecord.setCid(cid);
        expectedCampaignsRecord.setStrategyName(CampaignsStrategyName.autobudget_avg_cpa);
        expectedCampaignsRecord.setStrategyData(new StrategyDataJava()
                        .withPayForConversion(0)
                        .withAvgCpa(AVERAGE_CPA.doubleValue())
                        .withName(CampaignsStrategyName.autobudget_avg_cpa)
                        .withGoalId(goalId)
                        .withVersion(1)
                        .toJsonElement());
        assertThat("стратегия правильно сохранилась в базе", actualCampaignsRecord.intoMap(),
                beanDiffer(expectedCampaignsRecord.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
