package ru.yandex.autotests.direct.api.campaigns.add.textcampaign.settings;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 29.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.ADD)
@Description("Проверка настройки REQUIRE_SERVICING поля Settings")
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
public class AddManagerAssistanceTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;
    private GetResponse getResponse;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public YesNoEnum settingValue;

    @Parameterized.Parameter(2)
    public YesNoEnum expectedValue;

    @Parameterized.Parameters(name = "login = {0}, value = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsLogins.SERV_CLIENT, YesNoEnum.NO, YesNoEnum.NO},
                {CampaignsLogins.SERV_CLIENT, YesNoEnum.YES, YesNoEnum.YES},
                {CampaignsLogins.GET_CLIENT, YesNoEnum.NO, YesNoEnum.NO},
                {CampaignsLogins.GET_CLIENT, YesNoEnum.YES, YesNoEnum.NO}
        };
        return Arrays.asList(data);
    }

    @Before
    public void addCampaign() {
        campaignID = api.as(login).userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withSettings(new TextCampaignSettingMap()
                                        .withOption(TextCampaignSettingsEnum.REQUIRE_SERVICING)
                                        .withValue(settingValue))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("203")
    public void checkSettings() {
        //DIRECT-45669, DIRECT-47031
        getResponse = api.as(login).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.SETTINGS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        assumeThat("вернулись текстовые параметры кампании", getResponse.getCampaigns().get(0).getTextCampaign(),
                notNullValue());
        List<TextCampaignSettingGet> settings = getResponse.getCampaigns().get(0).getTextCampaign().getSettings();
        assumeThat("вернулись Settings кампании", settings, notNullValue());

        List<YesNoEnum> value = settings.stream()
                .filter(setting -> setting.getOption().equals(TextCampaignSettingsGetEnum.REQUIRE_SERVICING))
                .map(setting -> setting.getValue()).collect(Collectors.toList());
        assertThat("вернулся ожидаемый параметр", value, equalTo(Arrays.asList(expectedValue)));
    }
}
