package ru.yandex.autotests.direct.api.campaigns.add.textcampaign.settings;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * Created by lightelfik on 15.06.17.
 * https://st.yandex-team.ru/DIRECT-66684
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-66684")
@Features(CampaignsFeatures.ADD)
@Description("Проверка поля SHARED_ACCOUNT_ENABLED в Settings")
@Tag(TagDictionary.TRUNK)
public class SharedAccountByDefaultTest {
    private static final String SUPER = CampaignsLogins.SUPER;
    private static final String SUBCLIENT = CampaignsLogins.SUBCLIENT_3;
    private static final String AGENCY_WITH_SA = CampaignsLogins.AGENCY_YE_DEFAULT;
    private static final String SUBCLIENT_WITH_SA = CampaignsLogins.ACCOUNT_SUBCLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SUPER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT);
        List<Long> campaignIds = api.userSteps.campaignSteps().getAllCampaignIds(SUBCLIENT);
        if (!campaignIds.isEmpty()) {
            api.userSteps.campaignSteps().campaignsDelete(
                    SUBCLIENT, campaignIds.stream().toArray(Long[]::new));
        }
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT_WITH_SA);
        campaignIds = api.userSteps.campaignSteps().getAllCampaignIds(SUBCLIENT_WITH_SA);
        if (!campaignIds.isEmpty()) {
            api.userSteps.campaignSteps().campaignsDelete(
                    SUBCLIENT_WITH_SA, campaignIds.stream().toArray(Long[]::new));
        }
    }

    @Test
    public void agencyWithoutSharedAccountTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                        ),
                SUBCLIENT,
                ExpectedResult.success()
        );
    }

    @Test
    public void agencyWithSharedAccountTest() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign(),
                SUBCLIENT_WITH_SA
        );
        int accountId = api.as(AGENCY_WITH_SA).userSteps.financeSteps().getAccountID(SUBCLIENT_WITH_SA);
        int shard = api.userSteps.clientFakeSteps().getUserShard(SUBCLIENT_WITH_SA);
        DirectJooqDbSteps jooqSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        long walletId = jooqSteps.campaignsSteps().getCampaignById(campaignId).getWalletCid();
        assertThat(walletId, equalTo(Long.valueOf(accountId)));
    }
}
