package ru.yandex.autotests.direct.api.campaigns.add.textcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка сохранения в базу поля campaigns.platform")
@Issue("https://st.yandex-team.ru/DIRECT-70914")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class StrategiesPlatformInDbTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    private Long cid;
    private int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public TextCampaignSearchStrategyTypeEnum searchStrategy;

    @Parameterized.Parameter(value = 1)
    public TextCampaignNetworkStrategyTypeEnum networkStrategy;

    @Parameterized.Parameter(value = 2)
    public CampaignsPlatform platform;

    @Parameterized.Parameters()
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION,
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE, CampaignsPlatform.both},
                {TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION,
                        TextCampaignNetworkStrategyTypeEnum.SERVING_OFF, CampaignsPlatform.search},
                {TextCampaignSearchStrategyTypeEnum.SERVING_OFF,
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE, CampaignsPlatform.context},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void saveInDbTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(searchStrategy))
                                .withNetwork(new TextCampaignNetworkStrategyAddMap()
                                        .withBiddingStrategyType(networkStrategy)))));
    }

    @Test
    public void platformTest() {
        CampaignsRecord campaignsRecord =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid);
        assertThat("campaigns.platfrom правильно сохранилось в базе",
                campaignsRecord.getPlatform(), equalTo(platform));
    }
}
