package ru.yandex.autotests.direct.api.campaigns.add.textcampaign.strategy;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка выдачи ошибки при сохранени в базу стратегии ImpressionsBelowSearch")
@Issue("https://st.yandex-team.ru/DIRECT-75766")
@Tag(TagDictionary.TRUNK)
public class StrategyImpressionsBelowSearchDbNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    private Long cid;
    private int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовим данные для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);

    }

    @Test
    public void saveInDbTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withTextCampaign(
                                        new TextCampaignAddItemMap().withBiddingStrategy(new TextCampaignStrategyAddMap()
                                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                                        .withBiddingStrategyType(
                                                                TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH))
                                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault())))
                        ),
                        ExpectedResult.errorsIgnoringDetails(new Notification(3500,
                                Api5ErrorDetails.STRATEGY_NOT_SUPPORTED,
                                TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH))
        );
    }

}
