package ru.yandex.autotests.direct.api.campaigns.add.textcampaign.strategy.avaragecpa;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategy;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.TurbolandingMetrikaCountersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.BsFrontTurbolandingRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.BsFrontTurbolandingResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.IntapiTurboLandingCounter;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.api.campaigns.BsFrontTestDataUtils.getDefaultTurboladingSaveRequest;
import static ru.yandex.autotests.direct.api.campaigns.BsFrontTestDataUtils.getTestIntapiTurbolanding;
import static ru.yandex.autotests.direct.api.campaigns.BsFrontTestDataUtils.testTurbolandingCounter;
import static ru.yandex.autotests.direct.api.campaigns.BsFrontTestDataUtils.testTurbolandingGoals;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверки параметра PayForConversion при создании кампании со стратегией AverageCpa")
@Tag(TagDictionary.TRUNK)
@Ignore //todo: причесать перед коммитом
public class StrategyAverageCpaAveragePayForConversionTest {
    private static final String client = CampaignsLogins.CLIENT_STRATEGY_PAY_FOR_CONVERSION;
    private static final Currency currency = Currency.RUB;

    private static final Money minAverageCpa = MoneyCurrency.get(currency).getMinAveragePrice();
    //private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Integer turbolandingCounterId = 62276813; //автоматический счетчик турбостраницы
    private static final Long payForConversionGoalId = 99450862L;  //цель с автоматического счетчика, помеченная как
    // конверсионная


    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    private TextCampaignStrategyMap expectedStrategyMap;

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        expectedStrategyMap = new TextCampaignStrategyMap()
                .withSearch(new TextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                        .withAverageCpa(new StrategyAverageCpaMap()
                                .withAverageCpa(minAverageCpa.getNext().bidLong().longValue())
                                .withGoalId(payForConversionGoalId)
                                //.withPayForConversion(YesNoEnum.YES)
                                .withBidCeiling(null)
                                .withWeeklySpendLimit(null)))
                .withNetwork(new TextCampaignNetworkStrategyMap().defaultServingOff());


        //если нет, создадим ее.
        int shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(client);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);

        createTurbolandingWithInternalCounterIfAbsent(jooqDbSteps, client, turbolandingCounterId);

    }

    /**
     * Проверяет, есть ли у клиента турбосраница с указанным автоматическим счетчиком.
     * Если нет, создает ее заново через intapi метод save_turbolandings()
     * При создании страницы использует все цели указанные в MetrikaGoals для счетчика turbolandingInternalCounter
     *
     * @param jooqDbSteps
     * @param login
     * @param turbolandingInternalCounter - берем счетчик из MetrikaGoals. Нужно чтобы у клиента предварительно был
     *                                    создан такой счетчик. Если
     * @return
     */
    private Long createTurbolandingWithInternalCounterIfAbsent(DirectJooqDbSteps jooqDbSteps, String login,
                                                               Integer turbolandingInternalCounter) {
        long clientId = jooqDbSteps.usersSteps().getUser(client).getClientid();
        long uid = jooqDbSteps.usersSteps().getUser(client).getUid();

        Optional<TurbolandingMetrikaCountersRecord> turbolandingMetrikaCountersRecord =
                jooqDbSteps.turboLandingsSteps().getTurboladindingInternalMetrikaCounters(clientId);

        if (turbolandingMetrikaCountersRecord.isPresent()
                && turbolandingInternalCounter.equals(turbolandingMetrikaCountersRecord.get().getCounter())) {
            return turbolandingMetrikaCountersRecord.get().getTlId();
        } else {
            Long nextTurbolandingId = jooqDbSteps.turboLandingsSteps().getNextTurbolandingIdForCreate();
            BsFrontTurbolandingRequest bsFrontRequest =
                    getTurboladingWithInnerCounterBsFrontRequest(
                            Collections.singletonList(payForConversionGoalId),
                            turbolandingInternalCounter,
                            nextTurbolandingId,
                            uid,
                            clientId);
            BsFrontTurbolandingResponse bsFrontChangeNotifyResponse =
                    api.userSteps.getDarkSideSteps().getBsFrontSteps().turbolandingChangeNotify(bsFrontRequest);
            return bsFrontRequest.getTurbolanding().getId();
        }
    }

    BsFrontTurbolandingRequest getTurboladingWithInnerCounterBsFrontRequest(List<Long> turbolandingGoalIds,
                                                                            Integer innerCounterIdAvailableForLogin,
                                                                            Long turbolandingId,
                                                                            Long uid, Long clientId) {
        IntapiTurboLandingCounter turboLandingCounter = testTurbolandingCounter(innerCounterIdAvailableForLogin,
                testTurbolandingGoals(turbolandingGoalIds));

        return getDefaultTurboladingSaveRequest(
                clientId,
                uid,
                getTestIntapiTurbolanding(turbolandingId, Collections.singletonList(turboLandingCounter)));
    }

    @Test
    public void averageCpaCreateTest() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .withCounterIds(turbolandingCounterId)
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withSearch(new TextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                                                .withAverageCpa(new StrategyAverageCpaAddMap()
                                                        .withAverageCpa(minAverageCpa.getNext().bidLong().longValue())
                                                        .withGoalId(payForConversionGoalId)
                                                        //.withPayForConversion(YesNoEnum.YES)
                                                        .withBidCeiling(null)
                                                        .withWeeklySpendLimit(null)))
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                ExpectedResult.success());

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(response.getAddResults().get(0).getId()))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY));


        assumeThat("получили результаты обновления кампании", response.getAddResults(), hasSize(1));

        assumeThat("получили кампанию", campaigns, hasSize(1));
        TextCampaignStrategy actualStrategy = campaigns.get(0).getTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((TextCampaignStrategy) expectedStrategyMap.getBean()));
    }
}
