package ru.yandex.autotests.direct.api.campaigns.add.textcampaign.strategy.averagecpc;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 02.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра WeeklySpendLimit при добавлении кампании со стратегией AverageCpc")
public class StrategyAverageCpcWeeklySpendLimitNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private static final Money averagePrice = moneyCurrency.getMinAveragePrice().bidLong();
    private static final Money minLimit = moneyCurrency.getMinWeeklyBudgetAmount();
    private static final Money maxLimit = moneyCurrency.getMaxWeeklyBudgetAmount();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long weeklyLimit;

    @Parameterized.Parameter(value = 2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45834
                {"Нулевое значение", 0L,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(
                                        new Notification(4000,

                                                Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                                moneyCurrency.getApiDescription()),
                                        new Notification(4000,
                                                Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                                moneyCurrency.getApiDescription())
                                ))
                                .perl(ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription())))},
                {"Отрицательное значение", -1L,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(
                                        new Notification(4000,
                                                Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                                moneyCurrency.getApiDescription()),
                                        new Notification(4000,
                                                Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                                moneyCurrency.getApiDescription())
                                ))
                                .perl(ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription())))},
                {"Значение меньше минимального", minLimit.getPrevious().bidLong().longValue(),
                        JavaOrPerlExpectedResult.both(ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription())))},
                {"Значение больше максимального", maxLimit.getNext().bidLong().longValue(),
                        JavaOrPerlExpectedResult.both(ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_LIMIT_IS_TOO_HIGH,
                                maxLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                moneyCurrency.getApiDescription())))}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("214")
    public void weeklyLimitNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withSearch(new TextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                                                .withAverageCpc(new StrategyAverageCpcAddMap()
                                                        .withWeeklySpendLimit(weeklyLimit)
                                                        .withAverageCpc(averagePrice.longValue())))
                                        .withNetwork(
                                                new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault())))),
                expectedResult);
    }
}
