package ru.yandex.autotests.direct.api.campaigns.add.textcampaign.strategy.averagecrr;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCrrAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии создания кампании со стратегией AverageCrr")
public class StrategyAverageCrrNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Integer COUNTER_ID = MetrikaGoals.getCounterForLogin(client);
    private static final Money MIN_LIMIT = MoneyCurrency.get(Currency.RUB).getMinWeeklyBudgetAmount();
    private static final Money MAX_LIMIT = MoneyCurrency.get(Currency.RUB).getMaxWeeklyBudgetAmount();

    private TextCampaignStrategyAddMap strategyMap;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public StrategyAverageCrrAddMap strategyData;
    
    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {
                    "ДРР меньше 1%",
                    new StrategyAverageCrrAddMap()
                            .withCrr(StrategyAverageCrrAddMap.MIN_CRR - 1)
                            .withWeeklySpendLimit(StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT)
                            .withGoalId(MetrikaGoals.getGoalForCounter(COUNTER_ID)), 
                    ExpectedResult.errorWithCode(4000),
                },
                {
                    "ДРР больше 500%",
                    new StrategyAverageCrrAddMap()
                            .withCrr(StrategyAverageCrrAddMap.MAX_CRR + 1)
                            .withWeeklySpendLimit(StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT)
                            .withGoalId(MetrikaGoals.getGoalForCounter(COUNTER_ID)),
                    ExpectedResult.errorWithCode(4000),
                },
                {
                    "Бюджет меньше минимального значения",
                    new StrategyAverageCrrAddMap()
                            .withCrr(StrategyAverageCrrAddMap.DEFAULT_CRR)
                            .withWeeklySpendLimit(MIN_LIMIT.getPrevious().bidLong().longValue())
                            .withGoalId(MetrikaGoals.getGoalForCounter(COUNTER_ID)),
                    ExpectedResult.errorWithCode(4000),
                },
                {
                    "Бюджет больше максимального значения",
                    new StrategyAverageCrrAddMap()
                            .withCrr(StrategyAverageCrrAddMap.DEFAULT_CRR)
                            .withWeeklySpendLimit(MAX_LIMIT.getNext().bidLong().longValue())
                            .withGoalId(MetrikaGoals.getGoalForCounter(COUNTER_ID)),
                    ExpectedResult.errorWithCode(4000),
                },
                {
                    "Цель не задана",
                    new StrategyAverageCrrAddMap()
                            .withCrr(StrategyAverageCrrAddMap.DEFAULT_CRR)
                            .withWeeklySpendLimit(StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT),
                    ExpectedResult.errorWithCode(4000),
                }
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearUnits() {
        strategyMap = new TextCampaignStrategyAddMap()
                .withSearch(new TextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                        .withAverageCrr(strategyData)
                ).withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff());
    }
    
    @Test
    public void shouldReturnError() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .withCounterIds(COUNTER_ID)
                                .withBiddingStrategy(strategyMap)
                        )
                ),
                expectedResult
        );
    }
}
