package ru.yandex.autotests.direct.api.campaigns.add.textcampaign.strategy.bids;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategy;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 11.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Проверка ставок по умолчанию для ключевого слова при создании текстовой кампании с автоматическими стратегиями")
@Tag(TagDictionary.TRUNK)
public class StrategyDefaultBidsAutoTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final Money defaultBid = MoneyCurrency.get(currency).getMinPrice();

    private static TextCampaignStrategyAddMap strategyMap;
    private static TextCampaignStrategyMap expectedStrategyMap;

    private Long campaignId;
    private Long groupId;
    private Long keywordId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public TextCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public TextCampaignSearchStrategyMap expectedSearchStrategy;

    @Parameterized.Parameter(value = 4)
    public TextCampaignNetworkStrategyMap expectedNetworkStrategy;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Search: AverageCpc, Network: Disabled",
                        new TextCampaignSearchStrategyAddMap().defaultAverageCpc(currency),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap().defaultAverageCpc(currency),
                        new TextCampaignNetworkStrategyMap().defaultServingOff()},
                {"Search: MaximumClicks, Network: Disabled",
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(currency),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new TextCampaignNetworkStrategyMap().defaultServingOff()},

                {"Search: AverageCpc, Network: NetworkDefault",
                        new TextCampaignSearchStrategyAddMap().defaultAverageCpc(currency),
                        new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault(),
                        new TextCampaignSearchStrategyMap().defaultAverageCpc(currency),
                        new TextCampaignNetworkStrategyMap().withBiddingStrategyType(
                                TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)},
                {"Search: MaximumClicks, Network: NetworkDefault",
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(currency),
                        new TextCampaignNetworkStrategyAddMap().defaultNetworkDefault(),
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new TextCampaignNetworkStrategyMap().withBiddingStrategyType(
                                TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)},

                {"Search: Disabled, Network: AverageCpc",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultAverageCpc(currency),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpc(currency)},
                {"Search: Disabled, Network: MaximumClicks",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultWbMaximumClicks(currency),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumClicks(currency)},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        strategyMap = new TextCampaignStrategyAddMap()
                .withSearch(searchStrategy)
                .withNetwork(networkStrategy);
        expectedStrategyMap = new TextCampaignStrategyMap()
                .withSearch(expectedSearchStrategy)
                .withNetwork(expectedNetworkStrategy);

        log.info("Создадим кампанию, группу, объявление и ключевое слово");
        List<Long> ids = api.userSteps.campaignSteps().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(strategyMap)));
        assumeThat("создана кампания", ids, hasSize(1));
        campaignId = ids.get(0);
        groupId = api.userSteps.adGroupsSteps().addDefaultGroup(ids.get(0));
        api.userSteps.adsSteps().addDefaultTextAd(groupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(groupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("216")
    public void defaultBidsTest() {
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        TextCampaignStrategy actualStrategy = campaigns.get(0).getTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());
        assumeThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((TextCampaignStrategy) expectedStrategyMap.getBean()));

        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordId);
        assumeThat("получили стратегии кампании", keywords, hasSize(1));

        KeywordGetItemMap expectedKeyword = new KeywordGetItemMap()
                .withBid(defaultBid.bidLong().longValue())
                .withContextBid(defaultBid.bidLong().longValue());
        assertThat("ставки по умолчанию для ключевого слова", keywords.get(0),
                beanEquivalentV5(expectedKeyword.getBean()));
    }
}
