package ru.yandex.autotests.direct.api.campaigns.add.textcampaign.strategy.networkdefault;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 02.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Проверка недопустимых значений параметра LimitPercent при добавлении кампании со стратегией NetworkDefault")
@Tag(TagDictionary.TRUNK)
public class StrategyNetworkDefaultNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Integer limitPercent;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Нулевой LimitPercent", 0,
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(5005, Api5ErrorDetails.LIMIT_PERCENT_SHOULD_BE_IN_INTERVAL))},
                {"Отрицательный LimitPercent", -10,
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(5005, Api5ErrorDetails.LIMIT_PERCENT_SHOULD_BE_IN_INTERVAL))},
                {"LimitPercent больше максимального", 110,
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(5005, Api5ErrorDetails.LIMIT_PERCENT_SHOULD_BE_IN_INTERVAL))},
                {"LimitPercent не кратен 10-ти", 71,
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(5005, Api5ErrorDetails.LIMIT_PERCENT_SHOULD_BE_MULTIPLE_OF_TEN))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("225")
    public void networkDefaultNegativeTest() {
        //DIRECT-46419
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition())
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap()
                                                .withBiddingStrategyType(
                                                        TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                                                .withNetworkDefault(new StrategyNetworkDefaultAddMap()
                                                        .withLimitPercent(limitPercent)))))),
                expectedResult);
    }
}
