package ru.yandex.autotests.direct.api.campaigns.add.timetargeting;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by semkagtn on 28.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка сохранения значения поля BidPercent в базе данных при различных значениях SuspendOnHolidays")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class HolidayScheduleBidPercentSaveToDatabaseTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    private static final int BID_PERCENT = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Запрос с указанием BidPercent и SuspendOnHolidays = NO")
    @ru.yandex.qatools.allure.annotations.TestCaseId("235")
    public void requestWithBidPercentWhenSuspendOnHolidaysNo() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTimeTargeting(new TimeTargetingAddMap()
                        .withConsiderWorkingWeekends(YesNoEnum.NO)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20)
                                .withBidPercent(BID_PERCENT)))
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .defaultMobileAppCampaign()));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        Integer actualBidPercent =
                campaign.getTimeTargeting().getHolidaysSchedule().getValue().getBidPercent();

        assertThat("значение поля BidPercent было сохранено верно", actualBidPercent, equalTo(BID_PERCENT));
    }

    @Test
    @Description("Запрос с указанием BidPercent и SuspendOnHolidays = YES")
    @ru.yandex.qatools.allure.annotations.TestCaseId("234")
    public void requestWithBidPercentWhenSuspendOnHolidaysYes() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTimeTargeting(new TimeTargetingAddMap()
                                .withConsiderWorkingWeekends(YesNoEnum.NO)
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                        .withSuspendOnHolidays(YesNoEnum.YES)
                                        .withBidPercent(BID_PERCENT)))
                        .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                                .defaultMobileAppCampaign())),
                ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                        Api5ErrorDetails.HOLIDAY_SHEDULE_CANT_CONTAINS_FIELD,
                        capitalize(TimeTargetingOnPublicHolidaysMap.BID_PERCENT))));
    }

    @Test
    @Description("Запрос без указания BidPercent и SuspendOnHolidays = NO")
    @ru.yandex.qatools.allure.annotations.TestCaseId("236")
    public void requestWithoutBidPercentWhenSuspendOnHolidaysNo() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTimeTargeting(new TimeTargetingAddMap()
                        .withConsiderWorkingWeekends(YesNoEnum.NO)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20)))
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .defaultMobileAppCampaign()));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        Integer actualBidPercent = campaign.getTimeTargeting().getHolidaysSchedule().getValue().getBidPercent();

        assertThat("значение поля BidPercent было сохранено верно", actualBidPercent,
                equalTo(TimeTargetingOnPublicHolidaysMap.DEFAULT_BID_PERCENT));
    }
}
