package ru.yandex.autotests.direct.api.campaigns.add.timetargeting;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 25.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка обязательных полей: поле ConsiderWorkingWeekends является обязательным")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class HolidayScheduleConsiderWorkingWeekendsMandatoryFieldTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Запрос без поля ConsiderWorkingWeekends")
    @ru.yandex.qatools.allure.annotations.TestCaseId("238")
    public void requestWithoutConsiderWorkingWeekends() {
        api.userSteps.campaignSteps()
                .expectErrorOnCampaignsAdd(new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                                .withTimeTargeting(new TimeTargetingAddMap()
                                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                                .withSuspendOnHolidays(YesNoEnum.YES)))),
                        new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                                capitalize(CampaignAddItemMap.TIME_TARGETING),
                                capitalize(TimeTargetingMap.CONSIDER_WORKING_WEEKENDS)));
    }
}
