package ru.yandex.autotests.direct.api.campaigns.add.timetargeting;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 04.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 * https://st.yandex-team.ru/TESTIRT-8346
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка сохранения значений StartHours, EndHours в полях структуры HolidaySchedule при создании")
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-34567"),
        @Issue("https://st.yandex-team.ru/DIRECT-50018")})
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class HolidayScheduleSaveToDatabaseStartEndHoursTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    private static final int START_HOUR = 5;
    private static final int END_HOUR = 19;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public TextCampaignStrategyAddMap strategy;

    @Parameterized.Parameters()
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {new TextCampaignStrategyAddMap()
                        .withSearch(new TextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                                .withAverageCpc(new StrategyAverageCpcAddMap()
                                        .withWeeklySpendLimit(MoneyCurrency.get(Currency.RUB)
                                                .getMaxWeeklyBudgetAmount().longValue())
                                        .withAverageCpc(MoneyCurrency.get(Currency.RUB)
                                                .getMinAveragePrice().bidLong().longValue()))
                        ).withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())},
                {new TextCampaignStrategyAddMap()
                        .withSearch(new TextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage())
                },
        });
    }


    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Проверка сохранения значения поля StartHour")
    @ru.yandex.qatools.allure.annotations.TestCaseId("241")
    public void checkStartHourFieldWithNeedShowYes() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign().withBiddingStrategy(strategy))
                .withTimeTargeting(new TimeTargetingAddMap()
                        .withConsiderWorkingWeekends(YesNoEnum.YES)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(START_HOUR)
                                .withEndHour(END_HOUR))));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        assumeThat("значени для HolidaysSchedule получено",
                campaign.getTimeTargeting().getHolidaysSchedule().getValue(), notNullValue());
        Integer actualStartHour = campaign.getTimeTargeting().getHolidaysSchedule().getValue().getStartHour();
        assertThat("значение поля StartHour соответствует ожидаемому", actualStartHour, equalTo(START_HOUR));
    }

    @Test
    @Description("Проверка сохранения значения поля EndHour")
    @ru.yandex.qatools.allure.annotations.TestCaseId("242")
    public void checkEndHourFieldWithNeedShowYes() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign().withBiddingStrategy(strategy))
                .withTimeTargeting(new TimeTargetingAddMap()
                        .withConsiderWorkingWeekends(YesNoEnum.YES)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(START_HOUR)
                                .withEndHour(END_HOUR))));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        assumeThat("значени для HolidaysSchedule получено",
                campaign.getTimeTargeting().getHolidaysSchedule().getValue(), notNullValue());
        Integer actualStartHour = campaign.getTimeTargeting().getHolidaysSchedule().getValue().getEndHour();
        assertThat("значение поля EndHour соответствует ожидаемому", actualStartHour, equalTo(END_HOUR));
    }
}
