package ru.yandex.autotests.direct.api.campaigns.add.timetargeting;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 25.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка того, что нельзя выставить значение Start или EndHour при SuspendOnHolidays = YES")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class HolidayScheduleStartEndHoursWhenSuspendOnHolidayYesTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Integer startHour;

    @Parameterized.Parameter(2)
    public Integer endHour;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"запрос с EndHour", null, 10, ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                        Api5ErrorDetails.HOLIDAY_SHEDULE_CANT_CONTAINS_FIELD,
                        capitalize(TimeTargetingOnPublicHolidaysMap.END_HOUR)))},
                {"запрос с StartHour", 5, null, ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                        Api5ErrorDetails.HOLIDAY_SHEDULE_CANT_CONTAINS_FIELD,
                        capitalize(TimeTargetingOnPublicHolidaysMap.START_HOUR)))},
                {"запрос со StartHour и EndHour", 5, 10, ExpectedResult.errorsIgnoringDetails(
                        new Notification(4000,
                                Api5ErrorDetails.HOLIDAY_SHEDULE_CANT_CONTAINS_FIELD,
                                capitalize(TimeTargetingOnPublicHolidaysMap.START_HOUR)),
                        new Notification(4000,
                                Api5ErrorDetails.HOLIDAY_SHEDULE_CANT_CONTAINS_FIELD,
                                capitalize(TimeTargetingOnPublicHolidaysMap.END_HOUR)))},
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("245")
    public void requestWithStartEndHours() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign()
                        .withTimeTargeting(new TimeTargetingAddMap()
                                .withConsiderWorkingWeekends(YesNoEnum.YES)
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                        .withSuspendOnHolidays(YesNoEnum.YES)
                                        .withStartHour(startHour)
                                        .withEndHour(endHour)))),
                expectedResult);
    }
}
