package ru.yandex.autotests.direct.api.campaigns.add.timetargeting;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 25.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка сохранения SuspendOnHolidays при создании кампании")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class HolidayScheduleSuspendOnHolidaySaveToDatabaseTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Сохранить значение SuspendOnHolidays = Yes")
    @ru.yandex.qatools.allure.annotations.TestCaseId("246")
    public void saveSuspendOnHolidaysYes() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign()
                .withTimeTargeting(new TimeTargetingAddMap()
                        .withConsiderWorkingWeekends(YesNoEnum.YES)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.YES))));

        CampaignGetItem actualCampaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        YesNoEnum suspendOnHolidays =
                actualCampaign.getTimeTargeting().getHolidaysSchedule().getValue().getSuspendOnHolidays();

        assertThat("значение поля SuspendOnHolidays соответствует ожидаемому", suspendOnHolidays,
                equalTo(YesNoEnum.YES));
    }

    @Test
    @Description("Сохранить значение SuspendOnHolidays = No")
    @ru.yandex.qatools.allure.annotations.TestCaseId("247")
    public void saveSuspendOnHolidaysNo() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign()
                .withTimeTargeting(new TimeTargetingAddMap()
                        .withConsiderWorkingWeekends(YesNoEnum.YES)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20))));

        CampaignGetItem actualCampaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        YesNoEnum suspendOnHolidays =
                actualCampaign.getTimeTargeting().getHolidaysSchedule().getValue().getSuspendOnHolidays();

        assertThat("значение поля SuspendOnHolidays соответствует ожидаемому", suspendOnHolidays,
                equalTo(YesNoEnum.NO));
    }
}
