package ru.yandex.autotests.direct.api.campaigns.add.timetargeting;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 04.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка сохранения ConsiderWorkingWeekends при создании")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class TimeTargetingSaveToDatabaseConsiderWorkingWeekendsTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Parameterized.Parameter(0)
    public YesNoEnum considerWorkingWeekends;

    @Parameterized.Parameters(name = "ConsiderWorkingWeekends = {0}")
    public static Iterable<Object[]> data() {
        return Stream.of(YesNoEnum.values())
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("252")
    public void saveConsiderWorkingWeekends() {
        long campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign()
                .withTimeTargeting(new TimeTargetingAddMap()
                        .withConsiderWorkingWeekends(considerWorkingWeekends)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.YES))));

        CampaignGetItem actualCampaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        CampaignGetItem expectedCampaign = (CampaignGetItem) new CampaignGetItemMap()
                .withTimeTargeting(new TimeTargetingMap()
                        .withConsiderWorkingWeekends(considerWorkingWeekends)).getBean();

        assertThat("значение поля ConsiderWorkingWeekends соответствует ожидаемому", actualCampaign,
                beanEquivalent(expectedCampaign));
    }
}
