package ru.yandex.autotests.direct.api.campaigns.archive;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 25.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.ARCHIVE)
@Description("Компенцсация минусов при архивации кампании при недостатке средств на полную компенсацию")
@Tag(TagDictionary.TRUNK)
public class ArchiveCampaignsCampaignWithMinusTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String managerLogin = Logins.MANAGER_GEO;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(managerLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private final Class managerWsdl = ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType.class;
    private final Class clientWsdl = ru.yandex.autotests.directapi.common.api45.APIPort_PortType.class;

    private static Long campaignID;
    private static String srvClient;
    private static final Currency currency = Currency.RUB;
    private static final Money sumToAdd = MoneyCurrency.get(currency).getMinInvoiceAmount();
    private static float minus = sumToAdd.floatValue() + 10f;

    @Rule
    public Trashman trasher = new Trashman(api);


    @Before
    @Step("Подготовим данные для теста")
    public void initTest() {
        log.info("Создадим сервисируемого клиента");
        CreateNewSubclientResponse createNewSubclientResponse =
                api.wsdl(managerWsdl).as(managerLogin).userSteps.clientSteps()
                        .createNewServicedSubClient("srvClient", managerLogin, Currency.RUB);
        api.wsdl(clientWsdl).userSteps.balanceSteps().createPersonPh(createNewSubclientResponse.getClientID());
        srvClient = createNewSubclientResponse.getLogin();

        log.info("Создадим субклиенту кампании и включим ОС");
        campaignID = api.userSteps.addActiveCampaign(srvClient, sumToAdd.addVAT().floatValue(), Currency.RUB);
        Integer accountID = api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().getAccountID(srvClient);
        Account account = api.as(managerLogin).userSteps.financeSteps().getAccount(accountID);
        log.info("Дождемся появления средств на ОС");
        ConditionFactories.NOTIFY_PAYMENT.until(api.userSteps.financeSteps().accountAmountIs(account, true),
                equalTo(sumToAdd.floatValue()));

        log.info("Создадим открутки на кампании");
        api.userSteps.balanceSteps().doCampaigns(campaignID.intValue(), sumToAdd.add(10f).addVAT().floatValue());
        api.userSteps.balanceSteps().synchronizeCompletionQty(campaignID.intValue());
        ConditionFactories.NOTIFY_PAYMENT.until(api.userSteps.financeSteps().accountAmountIs(account, true),
                equalTo(sumToAdd.subtract(minus).floatValue()));
        CampaignFakeInfo campaignInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(campaignID);
        assumeThat("на кампанию не было компенсаций", campaignInfo.getSum(), equalTo(0f));
    }

    @Test
    @Description("Попробуем заархивировать кампанию, у которой недостаточно средств на ОС для компенсации минусов")
    //DIRECT-57070
    @ru.yandex.qatools.allure.annotations.TestCaseId("256")
    public void archiveCampaignWithInsufficientAmountOnAccountTest() {
        api.userSteps.campaignFakeSteps().makeCampaignStopped(campaignID);
        api.userSteps.campaignSteps().shouldGetResultOn(
                srvClient,
                Action.ARCHIVE,
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.success());
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps()
                        .campaignsGet(srvClient, campaignID, CampaignFieldEnum.ID, CampaignFieldEnum.STATE);
        assertThat("вернулись кампания ожидаемого типа",
                campaignGetItem,
                beanDifferV5(new CampaignGetItemMap()
                        .withId(campaignID)
                        .withState(CampaignStateGetEnum.ARCHIVED).getBean()
                )
        );
        api.userSteps.balanceSteps().synchronizeWithBalance(campaignID);
        assertThat("средства на кампании не компенсировались",
                api.userSteps.campaignFakeSteps().fakeGetCampaignParams(campaignID).getSum(), equalTo(0f));
    }
}
