package ru.yandex.autotests.direct.api.campaigns.archive;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.ARCHIVE)
@Description("Проверка негативных сценариев архивации кампаний от имени внутренних ролей")
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
public class ArchiveCampaignsRolesAccessNegativeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String campaignCreator;

    @Parameterized.Parameter(1)
    public String campaignArchiver;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "creator = {0}, archiver = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.SUPER_LOGIN, Logins.PLACER, CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        new Api5Error(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)},
                {Logins.SUPER_LOGIN, Logins.MEDIA, CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        new Api5Error(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)},
                {Logins.SUPER_LOGIN, Logins.SUPER_READER, CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        new Api5Error(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)},
        });
    }

    private Long campaignID;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(campaignArchiver);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(campaignCreator);

        log.info("Создадим кампанию от имени " + campaignCreator);
        campaignID = api.as(campaignCreator).userSteps.campaignSteps().addDefaultTextCampaign(client);
        api.userSteps.campaignSteps().campaignsSuspend(client, campaignID);
    }

    @Test
    public void archiveCampaignRolesNegativeTest() {
        api.as(campaignArchiver).userSteps.campaignSteps().shouldGetCampaignErrorOnIgnoringDetails(
                Action.ARCHIVE,
                client,
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                expectedError);
    }
}
