package ru.yandex.autotests.direct.api.campaigns.archive;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 18.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.ARCHIVE)
@Description("Удаление кампаний различных типов")
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
public class ArchiveCampaignsTypeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CampaignsLogins.SINGLE_CLIENT_ARCHIVE);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignID;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameter(value = 1)
    public Notification error;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.GEO, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.WALLET, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.MCB, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                // В джаве MCBANNER уже не входит в API5_VISIBLE,
                // а в перле он входит в API5 visible, но не входит в API5_EDIT_CAMPAIGNS
                // {CampaignsType.MCBANNER, new Notification(3500, Api5ErrorDetails.CAMPAIGN_TYPE_NOT_SUPPORTED)},
                {CampaignsType.CPM_DEALS, new Notification(3500, Api5ErrorDetails.CAMPAIGN_TYPE_NOT_SUPPORTED)},
        });
    }

    @BeforeClass
    public static void prepareCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsSuspend(campaignID);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void setType() {
        api.userSteps.campaignFakeSteps().setType(campaignID, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("292")
    public void archiveTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.ARCHIVE,
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.errors(error)
        );
    }
}
