package ru.yandex.autotests.direct.api.campaigns.delete;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 20.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.DELETE)
@Description("Проверка доступа агентства к кампаниям субклиента при удалении кампании")
@Tag(TagDictionary.TRUNK)
public class DeleteCampaignsAgencyAccessCampaignTest {
    private static final String singleClient = CampaignsLogins.SINGLE_CLIENT_DELETE;

    private static final String agency = CampaignsLogins.AGENCY_3;
    private static final String subclient1 = CampaignsLogins.SUBCLIENT_1;
    private static final String subclient2 = CampaignsLogins.SUBCLIENT_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
    }

    @Test
    @Description("Удалим агентством кампанию субклиента, указав кампанию другого сублиента")
    @ru.yandex.qatools.allure.annotations.TestCaseId("330")
    public void anotherSubсlientCampaignTest() {
        Long campaignID = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        api.userSteps.campaignSteps().shouldGetResultOn(
                subclient1,
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)));
    }

    @Test
    @Description("Удалим агентством кампанию субклиента, указав его кампанию и кампанию другого сублиента")
    @ru.yandex.qatools.allure.annotations.TestCaseId("331")
    public void ownedCampaignAndAnotherSubсlientCampaignTest() {
        Long campaignID1 = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        Long campaignID2 = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        api.userSteps.campaignSteps().shouldGetResultOn(
                subclient1,
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID1, campaignID2)),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)));
    }

    @Test
    @Description("Удалим агентством кампанию субклиента, указав кампанию самостоятельного клиента")
    @ru.yandex.qatools.allure.annotations.TestCaseId("332")
    public void nonOwnedCampaignByAgencyTest() {
        Long campaignID = api.as(singleClient).userSteps.campaignSteps().addDefaultTextCampaign();
        api.as(agency).userSteps.campaignSteps().shouldGetResultOn(
                subclient1,
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)));
    }
}
