package ru.yandex.autotests.direct.api.campaigns.delete;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusempty;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 20.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.DELETE)
@Description("Проверка статусов в БД при удалении кампании")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class DeleteCampaignsDBStatusTest {

    private static final String CLIENT = CampaignsLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;
    private static int shard;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(2)
    public BannerType bannerType;

    @Parameterized.Parameters(name = "campaignType = {0}, adGroupType = {1}, bannerType = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT},
                {CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC},
                {CampaignType.CPM_BANNER, AdGroupType.CPM_BANNER, BannerType.CPM_BANNER},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
    }

    @Before
    @Description("Подготовим данные для теста")
    public void initTest() {
        campaignID = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, adGroupType);
        if (bannerType == BannerType.CPM_BANNER) {
            DirectJooqDbSteps dbSteps =  api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
            Long creativeId = dbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                    Long.parseLong(User.get(CLIENT).getClientID()));
            api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(groupID, creativeId);
        } else {
            api.userSteps.adsSteps().addDefaultAd(groupID, bannerType);
        }
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("334")
    public void statusEmptyTest() {
        api.userSteps.campaignSteps().campaignsDelete(campaignID);
        CampaignsRecord campaign =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(campaignID);
        CampaignsStatusempty result = campaign == null ? CampaignsStatusempty.Yes : campaign.getStatusempty();
        assertThat("поле StatusEmpty после удаления кампании", result,
                equalTo(CampaignsStatusempty.Yes));
    }
}
