package ru.yandex.autotests.direct.api.campaigns.delete;

import java.util.Arrays;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 20.08.15.
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Удаление максимального числа кампаний в одном запросе")
@Tag(TagDictionary.NEVER_RUN)
public class DeleteCampaignsMaxIdsTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @Description(
            "Удаление максимального количества " + IdsCriteriaMap.CAMPAIGN_IDS_MAX_LENGTH + " кампаний в одном запросе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("339")
    public void deleteMaxCampaignIdsTest() {
        Long[] fakeIds = new Long[IdsCriteriaMap.CAMPAIGN_IDS_MAX_LENGTH];
        for (int i = 0; i < fakeIds.length; i++) {
            fakeIds[i] = Long.parseLong(RandomStringUtils.randomNumeric(9));
        }

        ExpectedResult[] expectedResults = new ExpectedResult[IdsCriteriaMap.CAMPAIGN_IDS_MAX_LENGTH];
        Arrays.fill(expectedResults,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)));

        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(fakeIds)),
                expectedResults);
    }
}
