package ru.yandex.autotests.direct.api.campaigns.delete;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 20.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.DELETE)
@Description("Удаление кампаний от имени внутренних ролей")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class DeleteCampaignsRolesAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String campaignCreator;

    @Parameterized.Parameter(1)
    public String campaignResumer;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "creator = {0}, resumer = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, CampaignsLogins.SERV_CLIENT,
                        ExpectedResult.success()},
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, CampaignsLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.success()},
                {Logins.SUPER_LOGIN, CampaignsLogins.SINGLE_CLIENT_DELETE, CampaignsLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.success()},
                {Logins.SUPER_LOGIN, CampaignsLogins.SINGLE_CLIENT_REP, CampaignsLogins.SINGLE_CLIENT,
                        ExpectedResult.success()},
                {CampaignsLogins.AGENCY_1_CAMPAIGNS, CampaignsLogins.AGENCY_1_CAMPAIGNS,
                        CampaignsLogins.SUBCLIENT_CAMPAIGNS,
                        ExpectedResult.success()},
                {CampaignsLogins.AGENCY_REP_CAMPAIGNS, CampaignsLogins.AGENCY_REP_CAMPAIGNS,
                        CampaignsLogins.SUBCLIENT_CAMPAIGNS,
                        ExpectedResult.success()},

                //DIRECT-46544
                {Logins.SUPER_LOGIN, Logins.PLACER, CampaignsLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_DELETE))},
                {Logins.SUPER_LOGIN, Logins.SUPPORT, CampaignsLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_DELETE))},
                {Logins.SUPER_LOGIN, Logins.MEDIA, CampaignsLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))},
                {Logins.SUPER_LOGIN, Logins.SUPER_READER, CampaignsLogins.SINGLE_CLIENT_DELETE,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))},
        });
    }

    private Long campaignID;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(campaignResumer);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(campaignCreator);

        log.info("Создадим кампанию от имени " + campaignCreator);
        api.as(campaignCreator);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("351")
    public void deleteCampaignRolesTest() {
        api.as(campaignResumer).userSteps.campaignSteps().shouldGetResultOn(
                client,
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                expectedResult);
    }
}
