package ru.yandex.autotests.direct.api.campaigns.delete;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 18.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.DELETE)
@Description("Удаление кампаний различных типов")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class DeleteCampaignsTypeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CampaignsLogins.SINGLE_CLIENT_DELETE);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameter(value = 1)
    public Notification error;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.GEO, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.WALLET, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.MCB, new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)},
                {CampaignsType.MCBANNER, new Notification(3500, Api5ErrorDetails.CAMPAIGN_TYPE_NOT_SUPPORTED)},
                {CampaignsType.CPM_DEALS, new Notification(3500, Api5ErrorDetails.CAMPAIGN_TYPE_NOT_SUPPORTED)},
        });
    }

    @Before
    @Step("Подготовим данные для теста")
    public void prepareCampaign() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignID, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("367")
    public void deleteTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.errors(error)
        );
    }
}
