package ru.yandex.autotests.direct.api.campaigns.delete;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.emptyIterable;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 24.09.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.DELETE)
@Description("Проверка позитивных сценариев удаления кампаний")
@Tag(TagDictionary.TRUNK)
public class DeleteMobileCampaignsPositiveTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_DELETE;
    private static final String clientAccount = CampaignsLogins.SINGLE_CLIENT_DELETE_ACCOUNT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignAccount;

    private static Long campaignIdMobile;
    private static Long campaignIdText;
    private static Long campaignID;
    private static Long campaignID1;
    private static Long campaignID2;

    @BeforeClass
    public static void prepareCampaigns() {
        campaignIdMobile = api.as(client).userSteps.campaignSteps().addDefaultMobileAppCampaign();
        campaignIdText = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignID = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        campaignID1 = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        campaignID2 = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        campaignAccount = api.as(clientAccount).userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("380")
    public void deleteSingleMobileCampaignTest() {
        api.as(client).userSteps.campaignSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.success(campaignID));
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignID);
        assertThat("кампания удалена", campaigns, emptyIterable());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("381")
    public void deleteTwoMobileCampaignsTest() {
        api.as(client).userSteps.campaignSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID1, campaignID2)),
                ExpectedResult.success(campaignID1),
                ExpectedResult.success(campaignID2));
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignID1, campaignID2);
        assertThat("кампании удалены", campaigns, emptyIterable());
    }

    @Test
    @Description("Удалим мобильную кампанию клиента с подключенным общим счётом")
    @ru.yandex.qatools.allure.annotations.TestCaseId("382")
    public void deleteSingleMobileCampaignAccountTest() {
        api.as(clientAccount).userSteps.campaignSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignAccount)),
                ExpectedResult.success(campaignAccount));
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignAccount);
        assertThat("кампания удалена", campaigns, emptyIterable());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("379")
    public void deleteCampaignsDifferentTypesTest() {
        api.as(client).userSteps.campaignSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignIdText, campaignIdMobile)),
                ExpectedResult.success(campaignIdText),
                ExpectedResult.success(campaignIdMobile));
        List<CampaignGetItem> campaigns =
                api.userSteps.campaignSteps().getCampaigns(campaignIdText, campaignIdMobile);
        assertThat("кампании удалены", campaigns, emptyIterable());
    }
}
