package ru.yandex.autotests.direct.api.campaigns.get;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.junit.Assert.assertThat;

/**
 * Created by pavryabov on 08.10.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка SOAP")
@Tag(TagDictionary.TRUNK)
public class CampaignsGetSOAPTest {

    private static final String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String GET_REQUEST = "GetRequest";
    private static Long id;

    @BeforeClass
    public static void createCampaign() {
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("383")
    public void emptyRequest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                new GetRequestMap(),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        GET_REQUEST, capitalize(GetRequestMap.FIELD_NAMES)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("384")
    public void getWithoutSelectionCriteria() {
        GetResponse response = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withFieldNames(CampaignFieldEnum.ID));
        assertThat("получили кампании", response.getCampaigns(),
                Matchers.not(Matchers.empty()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("385")
    public void getWithoutFieldNames() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        GET_REQUEST, capitalize(GetRequestMap.FIELD_NAMES)));
    }
}
