package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.cases.MinusWordsStorageCases;
import ru.yandex.autotests.directapi.converters.MinusWordsSerializer;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.junit.Assert.assertThat;

/**
 * Created by andy-ilyin on 13.09.16.
 * https://st.yandex-team.ru/TESTIRT-10213
 */
@Aqua.Test
@Features(CampaignsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-55547")
@Description("Проверка работы метода с новым JSON форматом минус-слов")
@RunWith(Parameterized.class)
public class GetCampaignNegativeKeywordsStorageTest {
    private static final List<MinusWordsSerializer> minusWordSerializers =
            Arrays.asList(MinusWordsSerializer.CURRENT_SERIALIZER);
    private static DirectJooqDbSteps dbSteps;
    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CampaignsLogins.GET_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativeKeywords;

    @Parameterized.Parameter(2)
    public MinusWordsSerializer minusWordSerializer;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        List<Object[]> result = new LinkedList<>();
        for (MinusWordsStorageCases.TestCase testCase : MinusWordsStorageCases.getTestCases()) {
            for (MinusWordsSerializer minusWordsSerializer : minusWordSerializers) {
                result.add(new Object[]{
                        testCase.getDescription() + " (" + minusWordsSerializer.toString() + ")",
                        testCase.getMinusWords().toArray(),
                        minusWordsSerializer
                });
            }
        }
        return result;
    }

    @BeforeClass
    public static void createCampaignAndAdGroup() {
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CampaignsLogins.GET_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CampaignsLogins.GET_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("387")
    public void testNegativeKeywordStorage() {
        dbSteps.campaignsSteps().updateCampOptions(
                new CampOptionsRecord()
                        .setCid(campaignId)
                        .setMinusWords(minusWordSerializer.write(Arrays.asList(negativeKeywords))));

        CampaignGetItem campaignGetItem = api.userSteps.campaignSteps()
                .campaignsGet(campaignId, CampaignFieldEnum.NEGATIVE_KEYWORDS);

        assertThat("минус-слова в ответе такие же, как сохранили в базу",
                campaignGetItem.getNegativeKeywords().getValue().getItems(),
                containsInAnyOrder(negativeKeywords));
    }
}
