package ru.yandex.autotests.direct.api.campaigns.get;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignsFeatures.GET)
@Description("Получение кампании с конверсионной стратегии с записанной датой последнего рестарта в биддере")
@Tag(TagDictionary.TRUNK)
public class GetCampaignWithLastBidderRestartTimeTest {
    private static final String client = CampaignsLogins.CLIENT_STRATEGY_WITH_LAST_BIDDER_RESTART_TIME;

    private static final Long goalId = MetrikaGoals.getGoalForLogin(client);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);
    private DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);

    private Long campaignId;

    @Before
    @Step("Подготовим данные для теста")
    public void prepare() {
        Long clientId = dbSteps.usersSteps().getUser(client).getClientid();
        dbSteps.featuresSteps().setClientFeature(clientId, "conversion_strategy_learning_status_enabled", true);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
        addWbMaximumConversionRateCampaign();
    }

    private Long addWbMaximumConversionRateCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        addGoals();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(new TextCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                                                .defaultWbMaximumConversionRate(Currency.RUB, goalId))
                                        .withNetwork(new TextCampaignNetworkStrategyMap().defaultServingOff())))),
                ExpectedResult.success());
        return campaignId;
    }

    private void addGoals() {
        dbSteps.campMetrikaGoalsSteps()
                .addOrUpdateMetrikaGoals(campaignId, goalId, 100L, 100L);
    }

    @Test
    public void getCampaignWithLastBidderRestartTimeInStrategy() {
        api.userSteps.campaignSteps().getCampaign(campaignId);
    }
}
