package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by voronov on 06.04.2016.
 */

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-52804")
@Features(CampaignsFeatures.GET)
@Description("Получение текстовой кампании различными внутренними ролями с правами на данную кампанию, при том что у владельца кампании нет баллов API5")
@RunWith(Parameterized.class)
public class GetCampaignsInternalRolesAccessToTextCampaignWithoutUnitsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String campaignCreator;

    @Parameterized.Parameter(1)
    public String campaignGetter;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameters(name = "creator = {0}, getter = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS, Logins.SUPER_LOGIN,
                        CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS},
                {CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS, Logins.SUPER_READER,
                        CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS},
                {CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS, Logins.PLACER,
                        CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS},
                {CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS, Logins.MEDIA,
                        CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS},
                {CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS, Logins.SUPPORT,
                        CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS},
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, CampaignsLogins.SERVICED_CLIENT_WITHOUT_UNITS}
        });
    }

    private Long id;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.as(campaignCreator);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        int units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(client, units);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("389")
    public void getCampaignInternalRolesTest() {
        GetResponse getResponse = api.as(campaignGetter).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID),
                client);
        assertThat("вернулась ожидаемая кампания",
                getResponse.getCampaigns(),
                beanDiffer(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap().withId(id).getBean()
                )));
    }
}
