package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAssistantMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsArrayMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 19.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка возврата nillable полей при значениях null при работе через JSON и SOAP")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetCampaignsNillableFieldsProtocolTest {
    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    @Parameterized.Parameter(0)
    public ProtocolType protocolType;

    @Parameterized.Parameters(name = "protocol = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {ProtocolType.JSON},
                {ProtocolType.SOAP}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Before
    public void setProtocol() {
        api.protocol(protocolType);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("393")
    public void getSourceID() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(id))
                .withFieldNames(CampaignFieldEnum.SOURCE_ID));
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(), beanDifferV5(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap().withSourceId(null).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("394")
    public void getRelevantKeywordsSetting() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.RELEVANT_KEYWORDS));
        assertThat("вернулся ожидаемый параметр", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(
                                        new TextCampaignGetItemMap().withRelevantKeywords(null)
                                ).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("395")
    public void getCounterIds() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.COUNTER_IDS));
        assertThat("вернулся ожидаемый параметр", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(
                                        new TextCampaignGetItemMap().withCounterIds((ArrayOfIntegerMap) null)
                                ).getBean())));
    }

    @Test
    public void getPriorityGoals() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.PRIORITY_GOALS));
        assertThat("вернулся ожидаемый параметр", getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withId(id)
                                .withTextCampaign(
                                        new TextCampaignGetItemMap().withPriorityGoals((PriorityGoalsArrayMap) null)
                                ).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("390")
    public void getRepresentedBy() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(id))
                .withFieldNames(CampaignFieldEnum.REPRESENTED_BY));
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(), beanDifferV5(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap()
                        .withRepresentedBy(
                                new CampaignAssistantMap()
                                        .withAgency(null)
                                        .withManager(null)).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("392")
    public void getEndDate() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(id))
                .withFieldNames(CampaignFieldEnum.END_DATE));
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(), beanDifferV5(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap().withEndDate(null).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("396")
    public void getByNegativeKeywords() {
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.NEGATIVE_KEYWORDS
                );
        assertThat("вернулся ожидаемый параметр", campaignGetItem,
                beanDifferV5(new CampaignGetItemMap()
                        .withNegativeKeywords((ArrayOfStringMap) null)
                        .getBean())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("397")
    public void getByBlockedIps() {
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.BLOCKED_IPS
                );
        assertThat("вернулся ожидаемый параметр", campaignGetItem,
                beanDifferV5(new CampaignGetItemMap()
                        .withBlockedIps((ArrayOfStringMap) null)
                        .getBean())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("398")
    public void getByExcludedSites() {
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.EXCLUDED_SITES
                );
        assertThat("вернулся ожидаемый параметр", campaignGetItem,
                beanDifferV5(new CampaignGetItemMap()
                        .withExcludedSites((ArrayOfStringMap) null)
                        .getBean())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("391")
    public void getDailyBudget() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(id))
                .withFieldNames(CampaignFieldEnum.DAILY_BUDGET));
        assertThat("вернулась правильная кампания", getResponse.getCampaigns(), beanDifferV5(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap().withDailyBudget(null).getBean())));
    }
}
