package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 23.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@Features(CampaignsFeatures.GET)
@Description("Получение динамической текстовой кампании различными ролями с правами на данную кампанию")
@RunWith(Parameterized.class)
public class GetCampaignsRolesAccessToDynamicTextCampaignTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String campaignCreator;

    @Parameterized.Parameter(1)
    public String campaignGetter;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameters(name = "creator = {0}, getter = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, CampaignsLogins.GET_CLIENT},
                {Logins.SUPER_LOGIN, Logins.SUPER_READER, CampaignsLogins.GET_CLIENT},
                {Logins.SUPER_LOGIN, Logins.PLACER, CampaignsLogins.GET_CLIENT},
                {Logins.SUPER_LOGIN, Logins.SUPPORT, CampaignsLogins.GET_CLIENT},
                {Logins.SUPER_LOGIN, Logins.MEDIA, CampaignsLogins.GET_CLIENT},
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, CampaignsLogins.SERV_CLIENT},
                {Logins.AGENCY_YE_DEFAULT, Logins.MANAGER_DEFAULT, CampaignsLogins.CLIENT_FREE_YE_DEFAULT},
                {CampaignsLogins.AGENCY_1_CAMPAIGNS, CampaignsLogins.AGENCY_1_CAMPAIGNS,
                        CampaignsLogins.SUBCLIENT_CAMPAIGNS},
                {CampaignsLogins.AGENCY_1_CAMPAIGNS, CampaignsLogins.AGENCY_REP_CAMPAIGNS,
                        CampaignsLogins.SUBCLIENT_CAMPAIGNS},
                {CampaignsLogins.AGENCY_1_CAMPAIGNS, CampaignsLogins.SUBCLIENT_CAMPAIGNS,
                        CampaignsLogins.SUBCLIENT_CAMPAIGNS},
                {Logins.AGENCY_YE_DEFAULT, Logins.API_SUBCLIENT, CampaignsLogins.API_SUBCLIENT},
                {Logins.SUPER_LOGIN, CampaignsLogins.GET_CLIENT, CampaignsLogins.GET_CLIENT},
                {Logins.SUPER_LOGIN, CampaignsLogins.SINGLE_CLIENT_REP, CampaignsLogins.SINGLE_CLIENT},
                {Logins.MANAGER_DEFAULT, Logins.AGENCY_YE_DEFAULT, CampaignsLogins.CLIENT_FREE_YE_DEFAULT},
        });
    }

    private Long id;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(campaignGetter);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(campaignCreator);
        api.as(campaignCreator);
        id = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("403")
    public void getCampaignRolesTest() {
        GetResponse getResponse = api.as(Logins.SUPER_LOGIN, campaignGetter).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID),
                client);
        assertThat("вернулась ожидаемая кампания",
                getResponse.getCampaigns(),
                beanDiffer(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap().withId(id).getBean()
                )));
    }
}
