package ru.yandex.autotests.direct.api.campaigns.get;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 18.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка логики поля TimeTargeting FiledNames")
@Tag(TagDictionary.TRUNK)
public class GetDefaultValueOfTimeTargetingTest {
    private static String client = CampaignsLogins.GET_CLIENT;
    public static String coef =
            ",100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private static Long id;
    private CampaignGetItem campaignGetItem;

    @BeforeClass
    public static void createCampaign() {
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("407")
    public void getByTimeTargeting() {
        campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.TIME_TARGETING
                );
        ArrayOfStringMap expectedShedule = new ArrayOfStringMap().withItems(
                "1" + coef,
                "2" + coef,
                "3" + coef,
                "4" + coef,
                "5" + coef,
                "6" + coef,
                "7" + coef);
        assertThat("вернулся ожидаемый параметр", campaignGetItem,
                beanDifferV5(new CampaignGetItemMap()
                        .withTimeTargeting(new TimeTargetingMap()
                                .withSchedule(expectedShedule)
                                .withConsiderWorkingWeekends(YesNoEnum.NO)
                                .withHolidaysSchedule(null))
                        .getBean())
        );
    }
}
