package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 22.07.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка фильтрации по Ids")
@Tag(TagDictionary.TRUNK)
public class GetIdsTest {

    private static String client = CampaignsLogins.GET_CLIENT;
    private static Long anotherClientCampaignId = 263L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id1;
    private static Long id2;
    private static Long deletedId;
    private GetResponse getResponse;

    @BeforeClass
    public static void createCampaign() {
        id1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        id2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        deletedId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsDelete(deletedId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("408")
    public void getByOneId() {
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id1,
                        CampaignFieldEnum.ID
                );
        assertThat("вернулся ожидаемый Id", campaignGetItem,
                beanDiffer(
                        (CampaignGetItem) new CampaignGetItemMap().withId(id1).getBean()
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("409")
    public void getBySomeIds() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id1,
                                                id2
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулись ожидаемые кампании",
                getResponse.getCampaigns(),
                beanDiffer(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap().withId(id1).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap().withId(id2).getBean()
                )));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("410")
    public void getByDuplicatedId() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id1,
                                                id1
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулась ожидаемая кампания",
                getResponse.getCampaigns(),
                beanDiffer(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap().withId(id1).getBean()
                )));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("411")
    public void getByNonExistentId() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id1 + 100000
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулась 0 кампаний", getResponse.getCampaigns(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("412")
    public void getByZeroId() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(0L)
                        )
                        .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулась 0 кампаний", getResponse.getCampaigns(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("413")
    public void getByNegativeId() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                -id1
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулась 0 кампаний", getResponse.getCampaigns(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("414")
    public void getByDeletedId() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                deletedId
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулась 0 кампаний", getResponse.getCampaigns(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("415")
    public void getAnotherClientId() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                anotherClientCampaignId
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулась 0 кампаний", getResponse.getCampaigns(), hasSize(0));
    }

}
