package ru.yandex.autotests.direct.api.campaigns.get;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignStateEnum;
import com.yandex.direct.api.v5.campaigns.CampaignStatusSelectionEnum;
import com.yandex.direct.api.v5.campaigns.CampaignTypeEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 30.07.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка невалидной стуктуры полей метода Get")
@Tag(TagDictionary.TRUNK)
public class GetInvalidJSONTest {
    private static String client = CampaignsLogins.GET_CLIENT;
    private static final String PARAMS = "params";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private Long id;
    private GetResponse getResponse;

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("416")
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(GetRequestMap.SELECTION_CRITERIA, selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
                        PARAMS, GetRequestMap.SELECTION_CRITERIA)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("418")
    public void invalidFieldInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(CampaignsSelectionCriteriaMap.IDS, new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
                        capitalize(GetRequestMap.SELECTION_CRITERIA), CampaignsSelectionCriteriaMap.IDS)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("419")
    public void invalidFieldInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        page.put(LimitOffsetMap.LIMIT, 1L);
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
                        capitalize(GetRequestMap.PAGE), LimitOffsetMap.LIMIT)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("417")
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY, PARAMS)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("420")
    public void arrayInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("421")
    public void arrayInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), 1L);
        request.put(capitalize(GetRequestMap.PAGE), new Object[]{page});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.PAGE))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("422")
    public void arrayInLimit() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), new Object[]{1L});
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(LimitOffsetMap.LIMIT))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("423")
    public void arrayInOffset() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), 1L);
        page.put(capitalize(LimitOffsetMap.OFFSET), new Object[]{1L});
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(LimitOffsetMap.OFFSET))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("424")
    public void notArrayInFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), CampaignFieldEnum.ID);
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("425")
    public void notArrayInTextCampaignFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        request.put(capitalize(GetRequestMap.TEXT_CAMPAIGN_FIELD_NAMES), TextCampaignFieldEnum.SETTINGS);
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.TEXT_CAMPAIGN_FIELD_NAMES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("426")
    public void notArrayInIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), id);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(CampaignsSelectionCriteriaMap.IDS))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("427")
    public void notArrayInTypes() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.TYPES), CampaignTypeEnum.TEXT_CAMPAIGN);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(CampaignsSelectionCriteriaMap.TYPES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("428")
    public void notArrayInStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.STATES), CampaignStateEnum.ON);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(CampaignsSelectionCriteriaMap.STATES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("429")
    public void notArrayInStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.STATUSES), CampaignStatusSelectionEnum.DRAFT);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(CampaignsSelectionCriteriaMap.STATUSES))
        );
    }
}
