package ru.yandex.autotests.direct.api.campaigns.get;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 30.07.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка невалидного типа полей метода Get")
@Tag(TagDictionary.TRUNK)
public class GetInvalidTypesOfFieldsTest {

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("431")
    public void invalidTypeOfLimit() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), "value");
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        capitalize(LimitOffsetMap.LIMIT))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("432")
    public void invalidTypeOfOffset() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), 1L);
        page.put(capitalize(LimitOffsetMap.OFFSET), "value");
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        capitalize(LimitOffsetMap.OFFSET))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("433")
    public void invalidTypeOfIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Object[]{"value"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        capitalize(CampaignsSelectionCriteriaMap.IDS))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("434")
    public void invalidTypeOfTypes() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.TYPES), new Object[]{"value"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(CampaignsSelectionCriteriaMap.TYPES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("435")
    public void invalidTypeOfStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.STATES), new Object[]{"value"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(CampaignsSelectionCriteriaMap.STATES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("436")
    public void invalidTypeOfStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.STATUSES), new Object[]{"value"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(CampaignsSelectionCriteriaMap.STATUSES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("437")
    public void invalidTypeOfFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{"value"});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("430")
    public void invalidTypeOfTextCampaignFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(CampaignsSelectionCriteriaMap.IDS), new Long[]{id});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{CampaignFieldEnum.ID});
        request.put(capitalize(GetRequestMap.TEXT_CAMPAIGN_FIELD_NAMES), new Object[]{"value"});
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.TEXT_CAMPAIGN_FIELD_NAMES))
        );
    }
}
