package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.ClientFakeInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAssistantMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 18.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка логики поля RepresentedBy")
@Tag(TagDictionary.TRUNK)
public class GetRepresentedByTest {

    private static String subclient = CampaignsLogins.GET_SUBCLIENT;
    private static String servclient = CampaignsLogins.GET_SERV_CLIENT;
    private static String client = CampaignsLogins.GET_CLIENT;
    private static String clientYE = Logins.CLIENT_FREE_YE_DEFAULT;
    private static String agency = CampaignsLogins.GET_AGENCY;
    private static String agencyYE = CampaignsLogins.AGENCY_YE_DEFAULT;
    private static String manager = CampaignsLogins.MANAGER_DEFAULT;
    private static final String FIO = "fio";
    private static final String NAME = "name";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    private CampaignGetItem campaignGetItem;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("454")
    public void checkRepresentedByInGetResponseOfClient() {
        api.as(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.REPRESENTED_BY
                );
        assertThat("вернулся ожидаемый параметр", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withRepresentedBy(
                                        new CampaignAssistantMap()
                                                .withAgency(null)
                                                .withManager(null)
                                ).getBean()));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("455")
    public void checkRepresentedByInGetResponseOfManagerClient() {
        api.as(manager);
        ClientFakeInfo clientInfo = api.userSteps.clientFakeSteps().getClientData(manager, new String[]{FIO});
        id = api.userSteps.campaignSteps().addDefaultTextCampaign(servclient);
        campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        servclient,
                        id,
                        CampaignFieldEnum.REPRESENTED_BY
                );
        assertThat("вернулся ожидаемый параметр", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withRepresentedBy(
                                        new CampaignAssistantMap()
                                                .withAgency(null)
                                                .withManager(clientInfo.getFio())
                                ).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("456")
    public void checkRepresentedByInGetResponseOfAgencyClient() {
        api.as(agency);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        subclient,
                        id,
                        CampaignFieldEnum.REPRESENTED_BY
                );
        assertThat("вернулся ожидаемый параметр", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withRepresentedBy(
                                        new CampaignAssistantMap()
                                                .withAgency(agency)
                                                .withManager(null)
                                ).getBean()));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("457")
    public void checkRepresentedByInGetResponseOfAgencyAndManagerClient() {
        api.as(agencyYE);
        ClientFakeInfo clientInfo = api.userSteps.clientFakeSteps().getClientData(agencyYE, new String[]{NAME});
        Long agencyId =
                api.userSteps.campaignSteps().addDefaultTextCampaign(clientYE);
        api.as(manager);
        Long managerId =
                api.userSteps.campaignSteps().addDefaultTextCampaign(clientYE);
        api.as(clientYE);
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(agencyId, managerId)
                        )
                        .withFieldNames(CampaignFieldEnum.REPRESENTED_BY),
                clientYE);
        assertThat("вернулся ожидаемый параметр", getResponse.getCampaigns(), beanDifferV5(
                Arrays.asList(
                        (CampaignGetItem)
                                new CampaignGetItemMap()
                                        .withRepresentedBy(
                                                new CampaignAssistantMap()
                                                        .withAgency(clientInfo.getName())
                                                        .withManager(null)
                                        ).getBean(),
                        (CampaignGetItem)
                                new CampaignGetItemMap()
                                        .withRepresentedBy(
                                                new CampaignAssistantMap()
                                                        .withAgency(clientInfo.getName())
                                                        .withManager(null)
                                        ).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("458")
    public void checkRepresentedByInGetResponseOfManagerForSubclient() {
        //https://st.yandex-team.ru/DIRECT-50575
        api.as(manager);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        subclient,
                        id,
                        CampaignFieldEnum.REPRESENTED_BY
                );
        assertThat("вернулся ожидаемый параметр", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withRepresentedBy(
                                        new CampaignAssistantMap()
                                                .withAgency(agency)
                                                .withManager(null)
                                ).getBean()));
    }


}
