package ru.yandex.autotests.direct.api.campaigns.get;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 29.07.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка обязательных полей метода Get")
@Tag(TagDictionary.TRUNK)
public class GetRequiredFieldsTest {
    private static String client = CampaignsLogins.GET_CLIENT;
    private static final String PARAMS = "params";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("459")
    public void emptyRequest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                new GetRequestMap(),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        PARAMS, capitalize(GetRequestMap.FIELD_NAMES)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("461")
    public void getWithoutFieldNames() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        PARAMS, capitalize(GetRequestMap.FIELD_NAMES)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("462")
    public void getWithEmptyArrayOfFieldNames() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id))
                        .withFieldNames(new CampaignFieldEnum[]{}),
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        capitalize(GetRequestMap.FIELD_NAMES)));
    }
}
