package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 22.07.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка размера массива SelectionCriteria.Ids")
@Tag(TagDictionary.TRUNK)
public class GetRestrictionTest {
    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("463")
    public void getWithMaxLengthOfIds() {
        Long[] ids = new Long[CampaignsSelectionCriteriaMap.IDS_MAX_SIZE];
        Arrays.fill(ids, id);
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                ids
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся ожидаемый Id", getResponse.getCampaigns(),
                beanDiffer(
                        Arrays.asList((CampaignGetItem) new CampaignGetItemMap().withId(id).getBean()
                        )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("464")
    public void getWithOverMaxLengthOfIds() {
        Long[] ids = new Long[CampaignsSelectionCriteriaMap.IDS_MAX_SIZE + 1];
        Arrays.fill(ids, id);

        api.userSteps.campaignSteps().shouldGetErrorOn(
                "Превышено допустимое количество идентификаторов в массиве SelectionCriteria.Ids",
                ServiceNames.CAMPAIGNS,
                client,
                Action.GET,
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                ids
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID),
                JavaOrPerlApi5Error
                        .java(new Api5Error(4001,
                                Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                                String.join(".",
                                        capitalize(GetRequestMap.SELECTION_CRITERIA),
                                        capitalize(CampaignsSelectionCriteriaMap.IDS))))
                        .perl(new Api5Error(4001,
                                Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                                capitalize(CampaignsSelectionCriteriaMap.IDS),
                                CampaignsSelectionCriteriaMap.IDS_MAX_SIZE)));
    }
}
